/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.jena.util.Locator;
import org.apache.jena.util.TypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LocatorURL
implements Locator {
    static Logger log = LoggerFactory.getLogger(LocatorURL.class);
    static final String acceptHeader = "application/rdf+xml,application/xml;q=0.9,*/*;q=0.5";
    static final String[] schemeNames = new String[]{"http:", "https:"};

    @Override
    public TypedStream open(String filenameOrURI) {
        if (!this.acceptByScheme(filenameOrURI)) {
            if (log.isTraceEnabled()) {
                log.trace("Not found : " + filenameOrURI);
            }
            return null;
        }
        try {
            URL url = new URL(filenameOrURI);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Accept", acceptHeader);
            conn.setRequestProperty("Accept-Charset", "utf-8,*");
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.connect();
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            if (log.isTraceEnabled()) {
                log.trace("Found: " + filenameOrURI);
            }
            return new TypedStream(in, conn.getContentType());
        }
        catch (FileNotFoundException ex) {
            if (log.isTraceEnabled()) {
                log.trace("LocatorURL: not found: " + filenameOrURI);
            }
            return null;
        }
        catch (MalformedURLException ex) {
            log.warn("Malformed URL: " + filenameOrURI);
            return null;
        }
        catch (UnknownHostException ex) {
            if (log.isTraceEnabled()) {
                log.trace("LocatorURL: not found (UnknownHostException): " + filenameOrURI);
            }
            return null;
        }
        catch (ConnectException ex) {
            if (log.isTraceEnabled()) {
                log.trace("LocatorURL: not found (ConnectException): " + filenameOrURI);
            }
            return null;
        }
        catch (SocketException ex) {
            if (log.isTraceEnabled()) {
                log.trace("LocatorURL: not found (SocketException): " + filenameOrURI);
            }
            return null;
        }
        catch (IOException ex) {
            log.warn("I/O Exception opening URL: " + filenameOrURI + "  " + ex.getMessage(), ex);
            return null;
        }
    }

    public boolean equals(Object other) {
        return other instanceof LocatorURL;
    }

    public int hashCode() {
        return LocatorURL.class.hashCode();
    }

    @Override
    public String getName() {
        return "LocatorURL";
    }

    private boolean acceptByScheme(String filenameOrURI) {
        String uriSchemeName = this.getScheme(filenameOrURI);
        if (uriSchemeName == null) {
            return false;
        }
        uriSchemeName = uriSchemeName.toLowerCase(Locale.ENGLISH);
        for (String schemeName : schemeNames) {
            if (!uriSchemeName.equals(schemeName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasScheme(String uri, String scheme) {
        String actualScheme = this.getScheme(uri);
        if (actualScheme == null) {
            return false;
        }
        return actualScheme.equalsIgnoreCase(scheme);
    }

    private String getScheme(String uri) {
        int ch = uri.indexOf(58);
        if (ch < 0) {
            return null;
        }
        return uri.substring(0, ch + 1);
    }
}

