/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.htmlparser.jericho.CharStreamSource;

public final class CharStreamSourceUtil {
    private static final int DEFAULT_ESTIMATED_MAXIMUM_OUTPUT_LENGTH = 2048;

    private CharStreamSourceUtil() {
    }

    public static Reader getReader(CharStreamSource charStreamSource) {
        return new StringReader(CharStreamSourceUtil.toString(charStreamSource));
    }

    public static String toString(CharStreamSource charStreamSource) {
        long l = charStreamSource.getEstimatedMaximumOutputLength();
        if (l <= -1L) {
            l = 2048L;
        }
        StringBuilder stringBuilder = new StringBuilder((int)l);
        try {
            charStreamSource.appendTo(stringBuilder);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringBuilder.toString();
    }
}

