/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLCreator;

public class NameNodeUrlCreator
implements ServiceURLCreator {
    private static final String SERVICE = "NAMENODE";
    private static final String NAMESERVICE_PARAM = "discovery-nameservice";
    private AmbariServiceDiscoveryMessages log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
    private AmbariCluster cluster;

    @Override
    public void init(AmbariCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public String getTargetService() {
        return SERVICE;
    }

    @Override
    public List<String> create(String service, Map<String, String> serviceParams) {
        ArrayList<String> urls = new ArrayList<String>();
        if (SERVICE.equals(service)) {
            if (serviceParams != null && serviceParams.containsKey(NAMESERVICE_PARAM)) {
                String declaredNameService = serviceParams.get(NAMESERVICE_PARAM);
                if (!NameNodeUrlCreator.validateDeclaredNameService(this.cluster, declaredNameService)) {
                    this.log.undefinedHDFSNameService(declaredNameService);
                } else {
                    urls.add("hdfs://" + declaredNameService);
                }
            } else {
                String defaultFS;
                AmbariCluster.ServiceConfiguration coreSite = this.cluster.getServiceConfiguration("HDFS", "core-site");
                if (coreSite != null && (defaultFS = coreSite.getProperties().get("fs.defaultFS")) != null) {
                    urls.add(defaultFS);
                }
            }
        }
        return urls;
    }

    private static boolean validateDeclaredNameService(AmbariCluster cluster, String declaredNameService) {
        String nameServices;
        boolean isValid = false;
        AmbariComponent nameNodeComp = cluster.getComponent(SERVICE);
        if (nameNodeComp != null && (nameServices = nameNodeComp.getConfigProperty("dfs.nameservices")) != null && !nameServices.isEmpty()) {
            String[] namespaces;
            for (String ns : namespaces = nameServices.split(",")) {
                if (!ns.equals(declaredNameService)) continue;
                isValid = true;
                break;
            }
        }
        return isValid;
    }
}

