/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public class ConverterEnum
extends AbstractCsvConverter {
    public ConverterEnum(Class<?> type, String locale, String writeLocale, Locale errorLocale) {
        super(type, locale, writeLocale, errorLocale);
    }

    @Override
    public Object convertToRead(String value) throws CsvDataTypeMismatchException {
        Enum o = null;
        if (StringUtils.isNotEmpty((CharSequence)value) && (o = EnumUtils.getEnumIgnoreCase((Class)this.type, (String)value)) == null) {
            throw new CsvDataTypeMismatchException(value, this.type, String.format(ResourceBundle.getBundle("opencsv").getString("illegal.enum.value"), value, this.type.getName()));
        }
        return o;
    }

    @Override
    public String convertToWrite(Object value) {
        String s2 = "";
        if (value != null) {
            Enum e = (Enum)value;
            s2 = e.name();
        }
        return s2;
    }
}

