/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import org.apache.uima.internal.util.IntArrayUtils;
import org.apache.uima.internal.util.IntVector;

public class SortedIntSet {
    private IntVector vector = new IntVector();

    public SortedIntSet() {
    }

    public SortedIntSet(int[] array) {
        this();
        for (int i = 0; i < array.length; ++i) {
            this.add(array[i]);
        }
    }

    public int find(int ele) {
        int[] array = this.vector.getArray();
        return IntArrayUtils.binarySearch(array, ele, 0, this.vector.size());
    }

    public boolean contains(int ele) {
        return this.find(ele) >= 0;
    }

    public boolean add(int ele) {
        int pos = this.find(ele);
        if (pos >= 0) {
            return false;
        }
        this.vector.add(-(pos + 1), ele);
        return true;
    }

    public boolean remove(int ele) {
        int pos = this.find(ele);
        if (pos < 0) {
            return false;
        }
        this.vector.remove(pos);
        return true;
    }

    public int size() {
        return this.vector.size();
    }

    public int get(int pos) {
        return this.vector.get(pos);
    }

    public void union(SortedIntSet set) {
        int max = set.size();
        for (int i = 0; i < max; ++i) {
            this.add(set.get(i));
        }
    }

    public void removeAll() {
        this.vector.removeAllElements();
    }

    public int[] toArray() {
        return this.vector.toArrayCopy();
    }

    public int[] getArray() {
        return this.vector.getArray();
    }
}

