/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack.sctp;

import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.SctpChannel;
import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.sctp.SCTPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.text.ParseException;

final class SCTPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Comparable<SCTPMessageChannel> {
    private static StackLogger logger = CommonLogger.getLogger(SCTPMessageChannel.class);
    private final SCTPMessageProcessor processor;
    private InetSocketAddress peerAddress;
    private InetSocketAddress peerSrcAddress;
    private final SctpChannel channel;
    private final SelectionKey key;
    private final MessageInfo messageInfo;
    private long rxTime;
    private final ByteBuffer rxBuffer = ByteBuffer.allocateDirect(10000);
    private final StringMsgParser parser = new StringMsgParser();

    SCTPMessageChannel(SCTPMessageProcessor p, InetSocketAddress dest) throws IOException {
        this.processor = p;
        this.messageProcessor = p;
        this.peerAddress = dest;
        this.peerSrcAddress = dest;
        this.messageInfo = MessageInfo.createOutgoing(dest, 0);
        this.messageInfo.unordered(true);
        this.channel = SctpChannel.open(dest, 1, 1);
        this.channel.configureBlocking(false);
        this.key = this.processor.registerChannel(this, this.channel);
    }

    SCTPMessageChannel(SCTPMessageProcessor p, SctpChannel c) throws IOException {
        this.processor = p;
        this.messageProcessor = p;
        SocketAddress a = c.getRemoteAddresses().iterator().next();
        this.peerAddress = (InetSocketAddress)a;
        this.peerSrcAddress = (InetSocketAddress)a;
        this.messageInfo = MessageInfo.createOutgoing(a, 0);
        this.messageInfo.unordered(true);
        this.channel = c;
        this.channel.configureBlocking(false);
        this.key = this.processor.registerChannel(this, this.channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.key.cancel();
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.processor.removeChannel(this);
        }
    }

    void closeNoRemove() {
        try {
            this.key.cancel();
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getKey() {
        return SCTPMessageChannel.getKey(this.getPeerInetAddress(), this.getPeerPort(), this.getTransport());
    }

    @Override
    public String getPeerAddress() {
        return this.peerAddress.getHostString();
    }

    @Override
    protected InetAddress getPeerInetAddress() {
        return this.peerAddress.getAddress();
    }

    @Override
    public InetAddress getPeerPacketSourceAddress() {
        return this.peerSrcAddress.getAddress();
    }

    @Override
    public int getPeerPacketSourcePort() {
        return this.peerSrcAddress.getPort();
    }

    @Override
    public int getPeerPort() {
        return this.peerAddress.getPort();
    }

    @Override
    protected String getPeerProtocol() {
        return "sctp";
    }

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.processor.getSIPStack();
    }

    @Override
    public String getTransport() {
        return "sctp";
    }

    @Override
    public String getViaHost() {
        return this.processor.getSavedIpAddress();
    }

    @Override
    public int getViaPort() {
        return this.processor.getPort();
    }

    @Override
    public boolean isReliable() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public void sendMessage(SIPMessage sipMessage) throws IOException {
        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
        this.sendMessage(msg, this.getPeerInetAddress(), this.getPeerPort(), false);
    }

    @Override
    protected void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean reconnectFlag) throws IOException {
        assert (receiverAddress.equals(this.peerAddress.getAddress()));
        assert (receiverPort == this.peerAddress.getPort());
        int nBytes = this.channel.send(ByteBuffer.wrap(message), this.messageInfo);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SCTP bytes sent:" + nBytes);
        }
    }

    void readMessages() throws IOException {
        MessageInfo info;
        if (this.rxTime == 0L) {
            this.rxTime = System.currentTimeMillis();
        }
        if ((info = this.channel.receive(this.rxBuffer, null, null)) == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SCTP read-event but no message");
            }
            return;
        }
        if (info.bytes() == -1) {
            logger.logWarning("SCTP peer closed, closing too...");
            this.close();
            return;
        }
        if (!info.isComplete()) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("SCTP incomplete message; bytes=" + info.bytes());
            }
            return;
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("SCTP message now complete; bytes=" + info.bytes());
        }
        byte[] msg = new byte[this.rxBuffer.position()];
        this.rxBuffer.flip();
        this.rxBuffer.get(msg);
        this.rxBuffer.compact();
        try {
            SIPMessage m = this.parser.parseSIPMessage(msg, true, true, this);
            this.processMessage(m, this.rxTime);
            this.rxTime = 0L;
        }
        catch (ParseException e) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Invalid message bytes=" + msg.length + ":" + new String(msg), e);
            }
            this.close();
            throw new IOException("Error parsing incoming SCTP message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(SIPMessage sipMessage, long rxTime) {
        SIPTransactionStack sipStack = this.processor.getSIPStack();
        sipMessage.setRemoteAddress(this.peerAddress.getAddress());
        sipMessage.setRemotePort(this.getPeerPort());
        sipMessage.setLocalPort(this.getPort());
        sipMessage.setLocalAddress(this.getMessageProcessor().getIpAddress());
        if (sipMessage instanceof SIPRequest) {
            ServerRequestInterface sipServerRequest;
            SIPRequest sipRequest = (SIPRequest)sipMessage;
            if (logger.isLoggingEnabled(16)) {
                sipStack.getServerLogger().logMessage(sipMessage, this.getPeerHostPort().toString(), this.getHost() + ":" + this.getPort(), false, rxTime);
            }
            if ((sipServerRequest = sipStack.newSIPServerRequest(sipRequest, this)) == null) {
                if (logger.isLoggingEnabled()) {
                    logger.logWarning("Null request interface returned -- dropping request");
                }
                return;
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("About to process " + sipRequest.getFirstLine() + "/" + sipServerRequest);
            }
            try {
                sipServerRequest.processRequest(sipRequest, this);
            }
            finally {
                SIPServerTransaction sipServerTx;
                if (sipServerRequest instanceof SIPTransaction && !(sipServerTx = (SIPServerTransaction)sipServerRequest).passToListener()) {
                    ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Done processing " + sipRequest.getFirstLine() + "/" + sipServerRequest);
            }
        } else {
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (logger.isLoggingEnabled()) {
                    logger.logError("Dropping Badly formatted response message >>> " + sipResponse);
                }
                return;
            }
            ServerResponseInterface sipServerResponse = sipStack.newSIPServerResponse(sipResponse, this);
            if (sipServerResponse != null) {
                try {
                    if (sipServerResponse instanceof SIPClientTransaction && !((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) {
                        if (logger.isLoggingEnabled()) {
                            logger.logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        return;
                    }
                    sipServerResponse.processResponse(sipResponse, this);
                }
                finally {
                    if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)((Object)sipServerResponse)).passToListener()) {
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    }
                }
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("null sipServerResponse!");
            }
        }
    }

    @Override
    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Parsing Exception: ", ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            block7: {
                String msgString;
                if (logger.isLoggingEnabled(32)) {
                    logger.logError("BAD MESSAGE!" + message);
                }
                if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ") && this.channel != null) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("Malformed mandatory headers: closing socket! :" + this.channel.toString());
                    }
                    try {
                        this.channel.close();
                    }
                    catch (IOException ie) {
                        if (!logger.isLoggingEnabled(4)) break block7;
                        logger.logError("Exception while closing socket! :" + this.channel.toString() + ":" + ie.toString());
                    }
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    @Override
    public int compareTo(SCTPMessageChannel o) {
        return this.hashCode() - o.hashCode();
    }

    @Override
    protected void uncache() {
        this.processor.removeChannel(this);
    }
}

