/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.search;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.ldap.client.api.search.AttributeDescriptionFilter;
import org.apache.directory.ldap.client.api.search.AttributeValueAssertionFilter;
import org.apache.directory.ldap.client.api.search.Filter;
import org.apache.directory.ldap.client.api.search.MatchingRuleAssertionFilterBuilder;
import org.apache.directory.ldap.client.api.search.SetOfFiltersFilter;
import org.apache.directory.ldap.client.api.search.SubstringFilter;
import org.apache.directory.ldap.client.api.search.UnaryFilter;

public class FilterBuilder {
    Filter filter;

    FilterBuilder(Filter filter) {
        this.filter = filter;
    }

    public static FilterBuilder and(FilterBuilder ... filters) {
        SetOfFiltersFilter filter = SetOfFiltersFilter.and(new Filter[0]);
        for (FilterBuilder builder : filters) {
            filter.add(builder.filter);
        }
        return new FilterBuilder(filter);
    }

    public static FilterBuilder approximatelyEqual(String attribute, String value) {
        return new FilterBuilder(AttributeValueAssertionFilter.approximatelyEqual(attribute, value));
    }

    public static FilterBuilder equal(String attribute, String value) {
        return new FilterBuilder(AttributeValueAssertionFilter.equal(attribute, value));
    }

    public static MatchingRuleAssertionFilterBuilder extensible(String value) {
        return new MatchingRuleAssertionFilterBuilder(null, value);
    }

    public static MatchingRuleAssertionFilterBuilder extensible(String attribute, String value) {
        return new MatchingRuleAssertionFilterBuilder(attribute, value);
    }

    public static FilterBuilder greaterThanOrEqual(String attribute, String value) {
        return new FilterBuilder(AttributeValueAssertionFilter.greaterThanOrEqual(attribute, value));
    }

    public static FilterBuilder lessThanOrEqual(String attribute, String value) {
        return new FilterBuilder(AttributeValueAssertionFilter.lessThanOrEqual(attribute, value));
    }

    public static FilterBuilder not(FilterBuilder builder) {
        return new FilterBuilder(UnaryFilter.not(builder.filter));
    }

    public static FilterBuilder or(FilterBuilder ... builders) {
        SetOfFiltersFilter filter = SetOfFiltersFilter.or(new Filter[0]);
        for (FilterBuilder builder : builders) {
            filter.add(builder.filter);
        }
        return new FilterBuilder(filter);
    }

    public static FilterBuilder present(String attribute) {
        return new FilterBuilder(AttributeDescriptionFilter.present(attribute));
    }

    public static FilterBuilder startsWith(String attribute, String ... parts) {
        if (parts == null || parts.length == 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04162_INITIAL_PART_NEEDED, new Object[0]));
        }
        return new FilterBuilder(SubstringFilter.startsWith(attribute, parts));
    }

    public static FilterBuilder endsWith(String attribute, String ... parts) {
        if (parts == null || parts.length == 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04163_FINAL_PART_NEEDED, new Object[0]));
        }
        return new FilterBuilder(SubstringFilter.endsWith(attribute, parts));
    }

    public static FilterBuilder contains(String attribute, String ... parts) {
        if (parts == null || parts.length == 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04164_ANY_PART_NEEDED, new Object[0]));
        }
        return new FilterBuilder(SubstringFilter.contains(attribute, parts));
    }

    public static FilterBuilder substring(String attribute, String ... parts) {
        if (parts == null || parts.length == 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04165_INITIAL_ANY_FINAL_PART_NEEDED, new Object[0]));
        }
        return new FilterBuilder(SubstringFilter.substring(attribute, parts));
    }

    public String toString() {
        return this.filter.build().toString();
    }
}

