/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class SearchQuery
extends EvalFunc<String> {
    private static Pattern queryPattern = Pattern.compile("(?<=([\\&\\?](as_)?[pq]=)).*?(\\z|(?=[\\&\\\"]))");

    public String exec(Tuple tuple) throws IOException {
        if (tuple == null || tuple.size() < 1) {
            return null;
        }
        try {
            String refURL = (String)tuple.get(0);
            return this.extractQuery(refURL);
        }
        catch (ExecException ee) {
            throw new IOException(ee);
        }
    }

    private String extractQuery(String url) {
        try {
            String refURL = url;
            if (refURL == null || refURL.isEmpty()) {
                return refURL;
            }
            String query = null;
            Matcher matcher = queryPattern.matcher(refURL = refURL.toLowerCase().trim());
            if (matcher.find()) {
                query = matcher.group();
                query = URLDecoder.decode(query, "UTF-8");
                query = query.replaceAll("[\\p{Punct}]+", "");
                query = (query = query.trim().replaceAll("[\\s]+", " ")).length() > 80 ? query.substring(0, 80) : query;
            }
            return query;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), new Schema(new Schema.FieldSchema(null, 55))));
        return funcList;
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema s = new Schema();
            s.add(new Schema.FieldSchema("query", 55));
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }
}

