/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_H_
#define PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_H_

#include <stdbool.h>
#include <stdint.h>
#include <plc4c/spi/context.h>
#include <plc4c/spi/read_buffer.h>
#include <plc4c/spi/write_buffer.h>
#include <plc4c/utils/list.h>
#include "memory_area.h"
#include "sub_item.h"
#include "transport_size.h"

// Code generated by code-generation. DO NOT EDIT.


// Structure used to contain the discriminator values for discriminated types using this as a parent
struct plc4c_s7_read_write_cyc_service_item_type_discriminator {
  uint8_t syntaxId;
};
typedef struct plc4c_s7_read_write_cyc_service_item_type_discriminator plc4c_s7_read_write_cyc_service_item_type_discriminator;

// Enum assigning each subtype an individual id.
enum plc4c_s7_read_write_cyc_service_item_type_type {
  plc4c_s7_read_write_cyc_service_item_type_type_plc4c_s7_read_write_cyc_service_item_any_type = 0,
  plc4c_s7_read_write_cyc_service_item_type_type_plc4c_s7_read_write_cyc_service_item_db_read_type = 1};
typedef enum plc4c_s7_read_write_cyc_service_item_type_type plc4c_s7_read_write_cyc_service_item_type_type;

// Function to get the discriminator values for a given type.
plc4c_s7_read_write_cyc_service_item_type_discriminator plc4c_s7_read_write_cyc_service_item_type_get_discriminator(plc4c_s7_read_write_cyc_service_item_type_type type);

// Constant values.
uint8_t PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_FUNCTION_ID();

struct plc4c_s7_read_write_cyc_service_item_type {
  /* This is an abstract type so this property saves the type of this typed union */
  plc4c_s7_read_write_cyc_service_item_type_type _type;
  /* Properties */
  uint8_t function_id;
  uint8_t byte_length;
  uint8_t syntax_id;
  union {
    struct { /* CycServiceItemAnyType */
      plc4c_s7_read_write_transport_size cyc_service_item_any_type_transport_size;
      uint16_t cyc_service_item_any_type_length;
      uint16_t cyc_service_item_any_type_db_number;
      plc4c_s7_read_write_memory_area cyc_service_item_any_type_memory_area;
      uint32_t cyc_service_item_any_type_address : 24;
    };
    struct { /* CycServiceItemDbReadType */
      uint8_t cyc_service_item_db_read_type_number_of_areas;
      plc4c_list* cyc_service_item_db_read_type_items;
    };
  };
};
typedef struct plc4c_s7_read_write_cyc_service_item_type plc4c_s7_read_write_cyc_service_item_type;

// Create an empty NULL-struct
plc4c_s7_read_write_cyc_service_item_type plc4c_s7_read_write_cyc_service_item_type_null();

plc4c_return_code plc4c_s7_read_write_cyc_service_item_type_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_cyc_service_item_type** message);

plc4c_return_code plc4c_s7_read_write_cyc_service_item_type_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_cyc_service_item_type* message);

uint16_t plc4c_s7_read_write_cyc_service_item_type_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_cyc_service_item_type* message);

uint16_t plc4c_s7_read_write_cyc_service_item_type_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_cyc_service_item_type* message);

#endif  // PLC4C_S7_READ_WRITE_CYC_SERVICE_ITEM_TYPE_H_
