/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SALDataHvacActuator is the corresponding interface of SALDataHvacActuator
type SALDataHvacActuator interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SALData
	// GetHvacActuatorData returns HvacActuatorData (property field)
	GetHvacActuatorData() LightingData
	// IsSALDataHvacActuator is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSALDataHvacActuator()
	// CreateBuilder creates a SALDataHvacActuatorBuilder
	CreateSALDataHvacActuatorBuilder() SALDataHvacActuatorBuilder
}

// _SALDataHvacActuator is the data-structure of this message
type _SALDataHvacActuator struct {
	SALDataContract
	HvacActuatorData LightingData
}

var _ SALDataHvacActuator = (*_SALDataHvacActuator)(nil)
var _ SALDataRequirements = (*_SALDataHvacActuator)(nil)

// NewSALDataHvacActuator factory function for _SALDataHvacActuator
func NewSALDataHvacActuator(salData SALData, hvacActuatorData LightingData) *_SALDataHvacActuator {
	if hvacActuatorData == nil {
		panic("hvacActuatorData of type LightingData for SALDataHvacActuator must not be nil")
	}
	_result := &_SALDataHvacActuator{
		SALDataContract:  NewSALData(salData),
		HvacActuatorData: hvacActuatorData,
	}
	_result.SALDataContract.(*_SALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SALDataHvacActuatorBuilder is a builder for SALDataHvacActuator
type SALDataHvacActuatorBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(hvacActuatorData LightingData) SALDataHvacActuatorBuilder
	// WithHvacActuatorData adds HvacActuatorData (property field)
	WithHvacActuatorData(LightingData) SALDataHvacActuatorBuilder
	// WithHvacActuatorDataBuilder adds HvacActuatorData (property field) which is build by the builder
	WithHvacActuatorDataBuilder(func(LightingDataBuilder) LightingDataBuilder) SALDataHvacActuatorBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SALDataBuilder
	// Build builds the SALDataHvacActuator or returns an error if something is wrong
	Build() (SALDataHvacActuator, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SALDataHvacActuator
}

// NewSALDataHvacActuatorBuilder() creates a SALDataHvacActuatorBuilder
func NewSALDataHvacActuatorBuilder() SALDataHvacActuatorBuilder {
	return &_SALDataHvacActuatorBuilder{_SALDataHvacActuator: new(_SALDataHvacActuator)}
}

type _SALDataHvacActuatorBuilder struct {
	*_SALDataHvacActuator

	parentBuilder *_SALDataBuilder

	collectedErr []error
}

var _ (SALDataHvacActuatorBuilder) = (*_SALDataHvacActuatorBuilder)(nil)

func (b *_SALDataHvacActuatorBuilder) setParent(contract SALDataContract) {
	b.SALDataContract = contract
	contract.(*_SALData)._SubType = b._SALDataHvacActuator
}

func (b *_SALDataHvacActuatorBuilder) WithMandatoryFields(hvacActuatorData LightingData) SALDataHvacActuatorBuilder {
	return b.WithHvacActuatorData(hvacActuatorData)
}

func (b *_SALDataHvacActuatorBuilder) WithHvacActuatorData(hvacActuatorData LightingData) SALDataHvacActuatorBuilder {
	b.HvacActuatorData = hvacActuatorData
	return b
}

func (b *_SALDataHvacActuatorBuilder) WithHvacActuatorDataBuilder(builderSupplier func(LightingDataBuilder) LightingDataBuilder) SALDataHvacActuatorBuilder {
	builder := builderSupplier(b.HvacActuatorData.CreateLightingDataBuilder())
	var err error
	b.HvacActuatorData, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "LightingDataBuilder failed"))
	}
	return b
}

func (b *_SALDataHvacActuatorBuilder) Build() (SALDataHvacActuator, error) {
	if b.HvacActuatorData == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'hvacActuatorData' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SALDataHvacActuator.deepCopy(), nil
}

func (b *_SALDataHvacActuatorBuilder) MustBuild() SALDataHvacActuator {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SALDataHvacActuatorBuilder) Done() SALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSALDataBuilder().(*_SALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SALDataHvacActuatorBuilder) buildForSALData() (SALData, error) {
	return b.Build()
}

func (b *_SALDataHvacActuatorBuilder) DeepCopy() any {
	_copy := b.CreateSALDataHvacActuatorBuilder().(*_SALDataHvacActuatorBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSALDataHvacActuatorBuilder creates a SALDataHvacActuatorBuilder
func (b *_SALDataHvacActuator) CreateSALDataHvacActuatorBuilder() SALDataHvacActuatorBuilder {
	if b == nil {
		return NewSALDataHvacActuatorBuilder()
	}
	return &_SALDataHvacActuatorBuilder{_SALDataHvacActuator: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SALDataHvacActuator) GetApplicationId() ApplicationId {
	return ApplicationId_HVAC_ACTUATOR
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SALDataHvacActuator) GetParent() SALDataContract {
	return m.SALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SALDataHvacActuator) GetHvacActuatorData() LightingData {
	return m.HvacActuatorData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSALDataHvacActuator(structType any) SALDataHvacActuator {
	if casted, ok := structType.(SALDataHvacActuator); ok {
		return casted
	}
	if casted, ok := structType.(*SALDataHvacActuator); ok {
		return *casted
	}
	return nil
}

func (m *_SALDataHvacActuator) GetTypeName() string {
	return "SALDataHvacActuator"
}

func (m *_SALDataHvacActuator) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SALDataContract.(*_SALData).getLengthInBits(ctx))

	// Simple field (hvacActuatorData)
	lengthInBits += m.HvacActuatorData.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SALDataHvacActuator) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SALDataHvacActuator) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SALData, applicationId ApplicationId) (__sALDataHvacActuator SALDataHvacActuator, err error) {
	m.SALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SALDataHvacActuator"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SALDataHvacActuator")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	hvacActuatorData, err := ReadSimpleField[LightingData](ctx, "hvacActuatorData", ReadComplex[LightingData](LightingDataParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'hvacActuatorData' field"))
	}
	m.HvacActuatorData = hvacActuatorData

	if closeErr := readBuffer.CloseContext("SALDataHvacActuator"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SALDataHvacActuator")
	}

	return m, nil
}

func (m *_SALDataHvacActuator) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SALDataHvacActuator) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SALDataHvacActuator"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SALDataHvacActuator")
		}

		if err := WriteSimpleField[LightingData](ctx, "hvacActuatorData", m.GetHvacActuatorData(), WriteComplex[LightingData](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'hvacActuatorData' field")
		}

		if popErr := writeBuffer.PopContext("SALDataHvacActuator"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SALDataHvacActuator")
		}
		return nil
	}
	return m.SALDataContract.(*_SALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SALDataHvacActuator) IsSALDataHvacActuator() {}

func (m *_SALDataHvacActuator) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SALDataHvacActuator) deepCopy() *_SALDataHvacActuator {
	if m == nil {
		return nil
	}
	_SALDataHvacActuatorCopy := &_SALDataHvacActuator{
		m.SALDataContract.(*_SALData).deepCopy(),
		utils.DeepCopy[LightingData](m.HvacActuatorData),
	}
	_SALDataHvacActuatorCopy.SALDataContract.(*_SALData)._SubType = m
	return _SALDataHvacActuatorCopy
}

func (m *_SALDataHvacActuator) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
