/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataCurrentAlarmType is the corresponding interface of SecurityDataCurrentAlarmType
type SecurityDataCurrentAlarmType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataCurrentAlarmType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataCurrentAlarmType()
	// CreateBuilder creates a SecurityDataCurrentAlarmTypeBuilder
	CreateSecurityDataCurrentAlarmTypeBuilder() SecurityDataCurrentAlarmTypeBuilder
}

// _SecurityDataCurrentAlarmType is the data-structure of this message
type _SecurityDataCurrentAlarmType struct {
	SecurityDataContract
}

var _ SecurityDataCurrentAlarmType = (*_SecurityDataCurrentAlarmType)(nil)
var _ SecurityDataRequirements = (*_SecurityDataCurrentAlarmType)(nil)

// NewSecurityDataCurrentAlarmType factory function for _SecurityDataCurrentAlarmType
func NewSecurityDataCurrentAlarmType(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataCurrentAlarmType {
	_result := &_SecurityDataCurrentAlarmType{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataCurrentAlarmTypeBuilder is a builder for SecurityDataCurrentAlarmType
type SecurityDataCurrentAlarmTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataCurrentAlarmTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataCurrentAlarmType or returns an error if something is wrong
	Build() (SecurityDataCurrentAlarmType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataCurrentAlarmType
}

// NewSecurityDataCurrentAlarmTypeBuilder() creates a SecurityDataCurrentAlarmTypeBuilder
func NewSecurityDataCurrentAlarmTypeBuilder() SecurityDataCurrentAlarmTypeBuilder {
	return &_SecurityDataCurrentAlarmTypeBuilder{_SecurityDataCurrentAlarmType: new(_SecurityDataCurrentAlarmType)}
}

type _SecurityDataCurrentAlarmTypeBuilder struct {
	*_SecurityDataCurrentAlarmType

	parentBuilder *_SecurityDataBuilder

	collectedErr []error
}

var _ (SecurityDataCurrentAlarmTypeBuilder) = (*_SecurityDataCurrentAlarmTypeBuilder)(nil)

func (b *_SecurityDataCurrentAlarmTypeBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataCurrentAlarmType
}

func (b *_SecurityDataCurrentAlarmTypeBuilder) WithMandatoryFields() SecurityDataCurrentAlarmTypeBuilder {
	return b
}

func (b *_SecurityDataCurrentAlarmTypeBuilder) Build() (SecurityDataCurrentAlarmType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SecurityDataCurrentAlarmType.deepCopy(), nil
}

func (b *_SecurityDataCurrentAlarmTypeBuilder) MustBuild() SecurityDataCurrentAlarmType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataCurrentAlarmTypeBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataCurrentAlarmTypeBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataCurrentAlarmTypeBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataCurrentAlarmTypeBuilder().(*_SecurityDataCurrentAlarmTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSecurityDataCurrentAlarmTypeBuilder creates a SecurityDataCurrentAlarmTypeBuilder
func (b *_SecurityDataCurrentAlarmType) CreateSecurityDataCurrentAlarmTypeBuilder() SecurityDataCurrentAlarmTypeBuilder {
	if b == nil {
		return NewSecurityDataCurrentAlarmTypeBuilder()
	}
	return &_SecurityDataCurrentAlarmTypeBuilder{_SecurityDataCurrentAlarmType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataCurrentAlarmType) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataCurrentAlarmType(structType any) SecurityDataCurrentAlarmType {
	if casted, ok := structType.(SecurityDataCurrentAlarmType); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataCurrentAlarmType); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataCurrentAlarmType) GetTypeName() string {
	return "SecurityDataCurrentAlarmType"
}

func (m *_SecurityDataCurrentAlarmType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataCurrentAlarmType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataCurrentAlarmType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataCurrentAlarmType SecurityDataCurrentAlarmType, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataCurrentAlarmType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataCurrentAlarmType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataCurrentAlarmType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataCurrentAlarmType")
	}

	return m, nil
}

func (m *_SecurityDataCurrentAlarmType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataCurrentAlarmType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataCurrentAlarmType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataCurrentAlarmType")
		}

		if popErr := writeBuffer.PopContext("SecurityDataCurrentAlarmType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataCurrentAlarmType")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataCurrentAlarmType) IsSecurityDataCurrentAlarmType() {}

func (m *_SecurityDataCurrentAlarmType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataCurrentAlarmType) deepCopy() *_SecurityDataCurrentAlarmType {
	if m == nil {
		return nil
	}
	_SecurityDataCurrentAlarmTypeCopy := &_SecurityDataCurrentAlarmType{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataCurrentAlarmTypeCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataCurrentAlarmTypeCopy
}

func (m *_SecurityDataCurrentAlarmType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
