/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ModbusPDUReadWriteMultipleHoldingRegistersResponse is the corresponding interface of ModbusPDUReadWriteMultipleHoldingRegistersResponse
type ModbusPDUReadWriteMultipleHoldingRegistersResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ModbusPDU
	// GetValue returns Value (property field)
	GetValue() []byte
	// IsModbusPDUReadWriteMultipleHoldingRegistersResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsModbusPDUReadWriteMultipleHoldingRegistersResponse()
	// CreateBuilder creates a ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder
	CreateModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder() ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder
}

// _ModbusPDUReadWriteMultipleHoldingRegistersResponse is the data-structure of this message
type _ModbusPDUReadWriteMultipleHoldingRegistersResponse struct {
	ModbusPDUContract
	Value []byte
}

var _ ModbusPDUReadWriteMultipleHoldingRegistersResponse = (*_ModbusPDUReadWriteMultipleHoldingRegistersResponse)(nil)
var _ ModbusPDURequirements = (*_ModbusPDUReadWriteMultipleHoldingRegistersResponse)(nil)

// NewModbusPDUReadWriteMultipleHoldingRegistersResponse factory function for _ModbusPDUReadWriteMultipleHoldingRegistersResponse
func NewModbusPDUReadWriteMultipleHoldingRegistersResponse(value []byte) *_ModbusPDUReadWriteMultipleHoldingRegistersResponse {
	_result := &_ModbusPDUReadWriteMultipleHoldingRegistersResponse{
		ModbusPDUContract: NewModbusPDU(),
		Value:             value,
	}
	_result.ModbusPDUContract.(*_ModbusPDU)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder is a builder for ModbusPDUReadWriteMultipleHoldingRegistersResponse
type ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []byte) ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder
	// WithValue adds Value (property field)
	WithValue(...byte) ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ModbusPDUBuilder
	// Build builds the ModbusPDUReadWriteMultipleHoldingRegistersResponse or returns an error if something is wrong
	Build() (ModbusPDUReadWriteMultipleHoldingRegistersResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ModbusPDUReadWriteMultipleHoldingRegistersResponse
}

// NewModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder() creates a ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder
func NewModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder() ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder {
	return &_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder{_ModbusPDUReadWriteMultipleHoldingRegistersResponse: new(_ModbusPDUReadWriteMultipleHoldingRegistersResponse)}
}

type _ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder struct {
	*_ModbusPDUReadWriteMultipleHoldingRegistersResponse

	parentBuilder *_ModbusPDUBuilder

	collectedErr []error
}

var _ (ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) = (*_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder)(nil)

func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) setParent(contract ModbusPDUContract) {
	b.ModbusPDUContract = contract
	contract.(*_ModbusPDU)._SubType = b._ModbusPDUReadWriteMultipleHoldingRegistersResponse
}

func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) WithMandatoryFields(value []byte) ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder {
	return b.WithValue(value...)
}

func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) WithValue(value ...byte) ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder {
	b.Value = value
	return b
}

func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) Build() (ModbusPDUReadWriteMultipleHoldingRegistersResponse, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ModbusPDUReadWriteMultipleHoldingRegistersResponse.deepCopy(), nil
}

func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) MustBuild() ModbusPDUReadWriteMultipleHoldingRegistersResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) Done() ModbusPDUBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewModbusPDUBuilder().(*_ModbusPDUBuilder)
	}
	return b.parentBuilder
}

func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) buildForModbusPDU() (ModbusPDU, error) {
	return b.Build()
}

func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder) DeepCopy() any {
	_copy := b.CreateModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder().(*_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder creates a ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder
func (b *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) CreateModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder() ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder {
	if b == nil {
		return NewModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder()
	}
	return &_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder{_ModbusPDUReadWriteMultipleHoldingRegistersResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) GetErrorFlag() bool {
	return bool(false)
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) GetFunctionFlag() uint8 {
	return 0x17
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) GetResponse() bool {
	return bool(true)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) GetParent() ModbusPDUContract {
	return m.ModbusPDUContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) GetValue() []byte {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastModbusPDUReadWriteMultipleHoldingRegistersResponse(structType any) ModbusPDUReadWriteMultipleHoldingRegistersResponse {
	if casted, ok := structType.(ModbusPDUReadWriteMultipleHoldingRegistersResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ModbusPDUReadWriteMultipleHoldingRegistersResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) GetTypeName() string {
	return "ModbusPDUReadWriteMultipleHoldingRegistersResponse"
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ModbusPDUContract.(*_ModbusPDU).getLengthInBits(ctx))

	// Implicit Field (byteCount)
	lengthInBits += 8

	// Array field
	if len(m.Value) > 0 {
		lengthInBits += 8 * uint16(len(m.Value))
	}

	return lengthInBits
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ModbusPDU, response bool) (__modbusPDUReadWriteMultipleHoldingRegistersResponse ModbusPDUReadWriteMultipleHoldingRegistersResponse, err error) {
	m.ModbusPDUContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ModbusPDUReadWriteMultipleHoldingRegistersResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ModbusPDUReadWriteMultipleHoldingRegistersResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	byteCount, err := ReadImplicitField[uint8](ctx, "byteCount", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'byteCount' field"))
	}
	_ = byteCount

	value, err := readBuffer.ReadByteArray("value", int(byteCount))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("ModbusPDUReadWriteMultipleHoldingRegistersResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ModbusPDUReadWriteMultipleHoldingRegistersResponse")
	}

	return m, nil
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ModbusPDUReadWriteMultipleHoldingRegistersResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ModbusPDUReadWriteMultipleHoldingRegistersResponse")
		}
		byteCount := uint8(uint8(len(m.GetValue())))
		if err := WriteImplicitField(ctx, "byteCount", byteCount, WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'byteCount' field")
		}

		if err := WriteByteArrayField(ctx, "value", m.GetValue(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("ModbusPDUReadWriteMultipleHoldingRegistersResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ModbusPDUReadWriteMultipleHoldingRegistersResponse")
		}
		return nil
	}
	return m.ModbusPDUContract.(*_ModbusPDU).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) IsModbusPDUReadWriteMultipleHoldingRegistersResponse() {
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) deepCopy() *_ModbusPDUReadWriteMultipleHoldingRegistersResponse {
	if m == nil {
		return nil
	}
	_ModbusPDUReadWriteMultipleHoldingRegistersResponseCopy := &_ModbusPDUReadWriteMultipleHoldingRegistersResponse{
		m.ModbusPDUContract.(*_ModbusPDU).deepCopy(),
		utils.DeepCopySlice[byte, byte](m.Value),
	}
	_ModbusPDUReadWriteMultipleHoldingRegistersResponseCopy.ModbusPDUContract.(*_ModbusPDU)._SubType = m
	return _ModbusPDUReadWriteMultipleHoldingRegistersResponseCopy
}

func (m *_ModbusPDUReadWriteMultipleHoldingRegistersResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
