/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LldpManagementAddressType is the corresponding interface of LldpManagementAddressType
type LldpManagementAddressType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetAddressSubtype returns AddressSubtype (property field)
	GetAddressSubtype() uint32
	// GetAddress returns Address (property field)
	GetAddress() PascalString
	// GetIfSubtype returns IfSubtype (property field)
	GetIfSubtype() ManAddrIfSubtype
	// GetIfId returns IfId (property field)
	GetIfId() uint32
	// IsLldpManagementAddressType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLldpManagementAddressType()
	// CreateBuilder creates a LldpManagementAddressTypeBuilder
	CreateLldpManagementAddressTypeBuilder() LldpManagementAddressTypeBuilder
}

// _LldpManagementAddressType is the data-structure of this message
type _LldpManagementAddressType struct {
	ExtensionObjectDefinitionContract
	AddressSubtype uint32
	Address        PascalString
	IfSubtype      ManAddrIfSubtype
	IfId           uint32
}

var _ LldpManagementAddressType = (*_LldpManagementAddressType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_LldpManagementAddressType)(nil)

// NewLldpManagementAddressType factory function for _LldpManagementAddressType
func NewLldpManagementAddressType(addressSubtype uint32, address PascalString, ifSubtype ManAddrIfSubtype, ifId uint32) *_LldpManagementAddressType {
	if address == nil {
		panic("address of type PascalString for LldpManagementAddressType must not be nil")
	}
	_result := &_LldpManagementAddressType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		AddressSubtype:                    addressSubtype,
		Address:                           address,
		IfSubtype:                         ifSubtype,
		IfId:                              ifId,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LldpManagementAddressTypeBuilder is a builder for LldpManagementAddressType
type LldpManagementAddressTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(addressSubtype uint32, address PascalString, ifSubtype ManAddrIfSubtype, ifId uint32) LldpManagementAddressTypeBuilder
	// WithAddressSubtype adds AddressSubtype (property field)
	WithAddressSubtype(uint32) LldpManagementAddressTypeBuilder
	// WithAddress adds Address (property field)
	WithAddress(PascalString) LldpManagementAddressTypeBuilder
	// WithAddressBuilder adds Address (property field) which is build by the builder
	WithAddressBuilder(func(PascalStringBuilder) PascalStringBuilder) LldpManagementAddressTypeBuilder
	// WithIfSubtype adds IfSubtype (property field)
	WithIfSubtype(ManAddrIfSubtype) LldpManagementAddressTypeBuilder
	// WithIfId adds IfId (property field)
	WithIfId(uint32) LldpManagementAddressTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the LldpManagementAddressType or returns an error if something is wrong
	Build() (LldpManagementAddressType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LldpManagementAddressType
}

// NewLldpManagementAddressTypeBuilder() creates a LldpManagementAddressTypeBuilder
func NewLldpManagementAddressTypeBuilder() LldpManagementAddressTypeBuilder {
	return &_LldpManagementAddressTypeBuilder{_LldpManagementAddressType: new(_LldpManagementAddressType)}
}

type _LldpManagementAddressTypeBuilder struct {
	*_LldpManagementAddressType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (LldpManagementAddressTypeBuilder) = (*_LldpManagementAddressTypeBuilder)(nil)

func (b *_LldpManagementAddressTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._LldpManagementAddressType
}

func (b *_LldpManagementAddressTypeBuilder) WithMandatoryFields(addressSubtype uint32, address PascalString, ifSubtype ManAddrIfSubtype, ifId uint32) LldpManagementAddressTypeBuilder {
	return b.WithAddressSubtype(addressSubtype).WithAddress(address).WithIfSubtype(ifSubtype).WithIfId(ifId)
}

func (b *_LldpManagementAddressTypeBuilder) WithAddressSubtype(addressSubtype uint32) LldpManagementAddressTypeBuilder {
	b.AddressSubtype = addressSubtype
	return b
}

func (b *_LldpManagementAddressTypeBuilder) WithAddress(address PascalString) LldpManagementAddressTypeBuilder {
	b.Address = address
	return b
}

func (b *_LldpManagementAddressTypeBuilder) WithAddressBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) LldpManagementAddressTypeBuilder {
	builder := builderSupplier(b.Address.CreatePascalStringBuilder())
	var err error
	b.Address, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_LldpManagementAddressTypeBuilder) WithIfSubtype(ifSubtype ManAddrIfSubtype) LldpManagementAddressTypeBuilder {
	b.IfSubtype = ifSubtype
	return b
}

func (b *_LldpManagementAddressTypeBuilder) WithIfId(ifId uint32) LldpManagementAddressTypeBuilder {
	b.IfId = ifId
	return b
}

func (b *_LldpManagementAddressTypeBuilder) Build() (LldpManagementAddressType, error) {
	if b.Address == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'address' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._LldpManagementAddressType.deepCopy(), nil
}

func (b *_LldpManagementAddressTypeBuilder) MustBuild() LldpManagementAddressType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LldpManagementAddressTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_LldpManagementAddressTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_LldpManagementAddressTypeBuilder) DeepCopy() any {
	_copy := b.CreateLldpManagementAddressTypeBuilder().(*_LldpManagementAddressTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateLldpManagementAddressTypeBuilder creates a LldpManagementAddressTypeBuilder
func (b *_LldpManagementAddressType) CreateLldpManagementAddressTypeBuilder() LldpManagementAddressTypeBuilder {
	if b == nil {
		return NewLldpManagementAddressTypeBuilder()
	}
	return &_LldpManagementAddressTypeBuilder{_LldpManagementAddressType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LldpManagementAddressType) GetExtensionId() int32 {
	return int32(18956)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LldpManagementAddressType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LldpManagementAddressType) GetAddressSubtype() uint32 {
	return m.AddressSubtype
}

func (m *_LldpManagementAddressType) GetAddress() PascalString {
	return m.Address
}

func (m *_LldpManagementAddressType) GetIfSubtype() ManAddrIfSubtype {
	return m.IfSubtype
}

func (m *_LldpManagementAddressType) GetIfId() uint32 {
	return m.IfId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLldpManagementAddressType(structType any) LldpManagementAddressType {
	if casted, ok := structType.(LldpManagementAddressType); ok {
		return casted
	}
	if casted, ok := structType.(*LldpManagementAddressType); ok {
		return *casted
	}
	return nil
}

func (m *_LldpManagementAddressType) GetTypeName() string {
	return "LldpManagementAddressType"
}

func (m *_LldpManagementAddressType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (addressSubtype)
	lengthInBits += 32

	// Simple field (address)
	lengthInBits += m.Address.GetLengthInBits(ctx)

	// Simple field (ifSubtype)
	lengthInBits += 32

	// Simple field (ifId)
	lengthInBits += 32

	return lengthInBits
}

func (m *_LldpManagementAddressType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LldpManagementAddressType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__lldpManagementAddressType LldpManagementAddressType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LldpManagementAddressType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LldpManagementAddressType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	addressSubtype, err := ReadSimpleField(ctx, "addressSubtype", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'addressSubtype' field"))
	}
	m.AddressSubtype = addressSubtype

	address, err := ReadSimpleField[PascalString](ctx, "address", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	ifSubtype, err := ReadEnumField[ManAddrIfSubtype](ctx, "ifSubtype", "ManAddrIfSubtype", ReadEnum(ManAddrIfSubtypeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ifSubtype' field"))
	}
	m.IfSubtype = ifSubtype

	ifId, err := ReadSimpleField(ctx, "ifId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ifId' field"))
	}
	m.IfId = ifId

	if closeErr := readBuffer.CloseContext("LldpManagementAddressType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LldpManagementAddressType")
	}

	return m, nil
}

func (m *_LldpManagementAddressType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LldpManagementAddressType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LldpManagementAddressType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LldpManagementAddressType")
		}

		if err := WriteSimpleField[uint32](ctx, "addressSubtype", m.GetAddressSubtype(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'addressSubtype' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "address", m.GetAddress(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'address' field")
		}

		if err := WriteSimpleEnumField[ManAddrIfSubtype](ctx, "ifSubtype", "ManAddrIfSubtype", m.GetIfSubtype(), WriteEnum[ManAddrIfSubtype, uint32](ManAddrIfSubtype.GetValue, ManAddrIfSubtype.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'ifSubtype' field")
		}

		if err := WriteSimpleField[uint32](ctx, "ifId", m.GetIfId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'ifId' field")
		}

		if popErr := writeBuffer.PopContext("LldpManagementAddressType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LldpManagementAddressType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LldpManagementAddressType) IsLldpManagementAddressType() {}

func (m *_LldpManagementAddressType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LldpManagementAddressType) deepCopy() *_LldpManagementAddressType {
	if m == nil {
		return nil
	}
	_LldpManagementAddressTypeCopy := &_LldpManagementAddressType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.AddressSubtype,
		utils.DeepCopy[PascalString](m.Address),
		m.IfSubtype,
		m.IfId,
	}
	_LldpManagementAddressTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _LldpManagementAddressTypeCopy
}

func (m *_LldpManagementAddressType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
