/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableSort is an enum
type OpcuaNodeIdServicesVariableSort int32

type IOpcuaNodeIdServicesVariableSort interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableSort_SortOrderType_EnumStrings OpcuaNodeIdServicesVariableSort = 18647
)

var OpcuaNodeIdServicesVariableSortValues []OpcuaNodeIdServicesVariableSort

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableSortValues = []OpcuaNodeIdServicesVariableSort{
		OpcuaNodeIdServicesVariableSort_SortOrderType_EnumStrings,
	}
}

func OpcuaNodeIdServicesVariableSortByValue(value int32) (enum OpcuaNodeIdServicesVariableSort, ok bool) {
	switch value {
	case 18647:
		return OpcuaNodeIdServicesVariableSort_SortOrderType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSortByName(value string) (enum OpcuaNodeIdServicesVariableSort, ok bool) {
	switch value {
	case "SortOrderType_EnumStrings":
		return OpcuaNodeIdServicesVariableSort_SortOrderType_EnumStrings, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableSortKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableSortValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableSort(structType any) OpcuaNodeIdServicesVariableSort {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableSort {
		if sOpcuaNodeIdServicesVariableSort, ok := typ.(OpcuaNodeIdServicesVariableSort); ok {
			return sOpcuaNodeIdServicesVariableSort
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableSort) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableSort) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableSortParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableSort, error) {
	return OpcuaNodeIdServicesVariableSortParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableSortParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableSort, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableSort", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableSort")
	}
	if enum, ok := OpcuaNodeIdServicesVariableSortByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableSort")
		return OpcuaNodeIdServicesVariableSort(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableSort) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableSort) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableSort", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableSort) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableSort) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableSort_SortOrderType_EnumStrings:
		return "SortOrderType_EnumStrings"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableSort) String() string {
	return e.PLC4XEnumName()
}
