/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MediaTransportControlDataEnumerationsSize extends MediaTransportControlData
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte sizeType;
  protected final short start;
  protected final short size;

  public MediaTransportControlDataEnumerationsSize(
      MediaTransportControlCommandTypeContainer commandTypeContainer,
      byte mediaLinkGroup,
      byte sizeType,
      short start,
      short size) {
    super(commandTypeContainer, mediaLinkGroup);
    this.sizeType = sizeType;
    this.start = start;
    this.size = size;
  }

  public byte getSizeType() {
    return sizeType;
  }

  public short getStart() {
    return start;
  }

  public short getSize() {
    return size;
  }

  public boolean getIsListCategories() {
    return (boolean) ((getSizeType()) == (0x00));
  }

  public boolean getIsListSelections() {
    return (boolean) ((getSizeType()) == (0x01));
  }

  public boolean getIsListTracks() {
    return (boolean) ((getSizeType()) == (0x02));
  }

  public boolean getIsReserved() {
    return (boolean)
        (((!(getIsListCategories())) && (!(getIsListSelections()))) && (!(getIsListTracks())));
  }

  @Override
  protected void serializeMediaTransportControlDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("MediaTransportControlDataEnumerationsSize");

    // Simple Field (sizeType)
    writeSimpleField("sizeType", sizeType, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isListCategories = getIsListCategories();
    writeBuffer.writeVirtual("isListCategories", isListCategories);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isListSelections = getIsListSelections();
    writeBuffer.writeVirtual("isListSelections", isListSelections);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isListTracks = getIsListTracks();
    writeBuffer.writeVirtual("isListTracks", isListTracks);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isReserved = getIsReserved();
    writeBuffer.writeVirtual("isReserved", isReserved);

    // Simple Field (start)
    writeSimpleField("start", start, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (size)
    writeSimpleField("size", size, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("MediaTransportControlDataEnumerationsSize");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MediaTransportControlDataEnumerationsSize _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (sizeType)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // Simple field (start)
    lengthInBits += 8;

    // Simple field (size)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static MediaTransportControlDataBuilder staticParseMediaTransportControlDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("MediaTransportControlDataEnumerationsSize");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte sizeType = readSimpleField("sizeType", readByte(readBuffer, 8));
    boolean isListCategories =
        readVirtualField("isListCategories", boolean.class, (sizeType) == (0x00));
    boolean isListSelections =
        readVirtualField("isListSelections", boolean.class, (sizeType) == (0x01));
    boolean isListTracks = readVirtualField("isListTracks", boolean.class, (sizeType) == (0x02));
    boolean isReserved =
        readVirtualField(
            "isReserved",
            boolean.class,
            ((!(isListCategories)) && (!(isListSelections))) && (!(isListTracks)));

    short start = readSimpleField("start", readUnsignedShort(readBuffer, 8));

    short size = readSimpleField("size", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("MediaTransportControlDataEnumerationsSize");
    // Create the instance
    return new MediaTransportControlDataEnumerationsSizeBuilderImpl(sizeType, start, size);
  }

  public static class MediaTransportControlDataEnumerationsSizeBuilderImpl
      implements MediaTransportControlData.MediaTransportControlDataBuilder {
    private final byte sizeType;
    private final short start;
    private final short size;

    public MediaTransportControlDataEnumerationsSizeBuilderImpl(
        byte sizeType, short start, short size) {
      this.sizeType = sizeType;
      this.start = start;
      this.size = size;
    }

    public MediaTransportControlDataEnumerationsSize build(
        MediaTransportControlCommandTypeContainer commandTypeContainer, byte mediaLinkGroup) {
      MediaTransportControlDataEnumerationsSize mediaTransportControlDataEnumerationsSize =
          new MediaTransportControlDataEnumerationsSize(
              commandTypeContainer, mediaLinkGroup, sizeType, start, size);
      return mediaTransportControlDataEnumerationsSize;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MediaTransportControlDataEnumerationsSize)) {
      return false;
    }
    MediaTransportControlDataEnumerationsSize that = (MediaTransportControlDataEnumerationsSize) o;
    return (getSizeType() == that.getSizeType())
        && (getStart() == that.getStart())
        && (getSize() == that.getSize())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getSizeType(), getStart(), getSize());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
