/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MediaTransportControlDataTotalTracks extends MediaTransportControlData
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte totalTracksMSB;
  protected final byte totalTracksMMSB;
  protected final byte totalTracksMLSB;
  protected final byte totalTracksLSB;

  public MediaTransportControlDataTotalTracks(
      MediaTransportControlCommandTypeContainer commandTypeContainer,
      byte mediaLinkGroup,
      byte totalTracksMSB,
      byte totalTracksMMSB,
      byte totalTracksMLSB,
      byte totalTracksLSB) {
    super(commandTypeContainer, mediaLinkGroup);
    this.totalTracksMSB = totalTracksMSB;
    this.totalTracksMMSB = totalTracksMMSB;
    this.totalTracksMLSB = totalTracksMLSB;
    this.totalTracksLSB = totalTracksLSB;
  }

  public byte getTotalTracksMSB() {
    return totalTracksMSB;
  }

  public byte getTotalTracksMMSB() {
    return totalTracksMMSB;
  }

  public byte getTotalTracksMLSB() {
    return totalTracksMLSB;
  }

  public byte getTotalTracksLSB() {
    return totalTracksLSB;
  }

  @Override
  protected void serializeMediaTransportControlDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("MediaTransportControlDataTotalTracks");

    // Simple Field (totalTracksMSB)
    writeSimpleField("totalTracksMSB", totalTracksMSB, writeByte(writeBuffer, 8));

    // Simple Field (totalTracksMMSB)
    writeSimpleField("totalTracksMMSB", totalTracksMMSB, writeByte(writeBuffer, 8));

    // Simple Field (totalTracksMLSB)
    writeSimpleField("totalTracksMLSB", totalTracksMLSB, writeByte(writeBuffer, 8));

    // Simple Field (totalTracksLSB)
    writeSimpleField("totalTracksLSB", totalTracksLSB, writeByte(writeBuffer, 8));

    writeBuffer.popContext("MediaTransportControlDataTotalTracks");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MediaTransportControlDataTotalTracks _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (totalTracksMSB)
    lengthInBits += 8;

    // Simple field (totalTracksMMSB)
    lengthInBits += 8;

    // Simple field (totalTracksMLSB)
    lengthInBits += 8;

    // Simple field (totalTracksLSB)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static MediaTransportControlDataBuilder staticParseMediaTransportControlDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("MediaTransportControlDataTotalTracks");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte totalTracksMSB = readSimpleField("totalTracksMSB", readByte(readBuffer, 8));

    byte totalTracksMMSB = readSimpleField("totalTracksMMSB", readByte(readBuffer, 8));

    byte totalTracksMLSB = readSimpleField("totalTracksMLSB", readByte(readBuffer, 8));

    byte totalTracksLSB = readSimpleField("totalTracksLSB", readByte(readBuffer, 8));

    readBuffer.closeContext("MediaTransportControlDataTotalTracks");
    // Create the instance
    return new MediaTransportControlDataTotalTracksBuilderImpl(
        totalTracksMSB, totalTracksMMSB, totalTracksMLSB, totalTracksLSB);
  }

  public static class MediaTransportControlDataTotalTracksBuilderImpl
      implements MediaTransportControlData.MediaTransportControlDataBuilder {
    private final byte totalTracksMSB;
    private final byte totalTracksMMSB;
    private final byte totalTracksMLSB;
    private final byte totalTracksLSB;

    public MediaTransportControlDataTotalTracksBuilderImpl(
        byte totalTracksMSB, byte totalTracksMMSB, byte totalTracksMLSB, byte totalTracksLSB) {
      this.totalTracksMSB = totalTracksMSB;
      this.totalTracksMMSB = totalTracksMMSB;
      this.totalTracksMLSB = totalTracksMLSB;
      this.totalTracksLSB = totalTracksLSB;
    }

    public MediaTransportControlDataTotalTracks build(
        MediaTransportControlCommandTypeContainer commandTypeContainer, byte mediaLinkGroup) {
      MediaTransportControlDataTotalTracks mediaTransportControlDataTotalTracks =
          new MediaTransportControlDataTotalTracks(
              commandTypeContainer,
              mediaLinkGroup,
              totalTracksMSB,
              totalTracksMMSB,
              totalTracksMLSB,
              totalTracksLSB);
      return mediaTransportControlDataTotalTracks;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MediaTransportControlDataTotalTracks)) {
      return false;
    }
    MediaTransportControlDataTotalTracks that = (MediaTransportControlDataTotalTracks) o;
    return (getTotalTracksMSB() == that.getTotalTracksMSB())
        && (getTotalTracksMMSB() == that.getTotalTracksMMSB())
        && (getTotalTracksMLSB() == that.getTotalTracksMLSB())
        && (getTotalTracksLSB() == that.getTotalTracksLSB())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getTotalTracksMSB(),
        getTotalTracksMMSB(),
        getTotalTracksMLSB(),
        getTotalTracksLSB());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
