/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class FindServersOnNetworkResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 12193;
  }

  // Properties.
  protected final ResponseHeader responseHeader;
  protected final long lastCounterResetTime;
  protected final List<ServerOnNetwork> servers;

  public FindServersOnNetworkResponse(
      ResponseHeader responseHeader, long lastCounterResetTime, List<ServerOnNetwork> servers) {
    super();
    this.responseHeader = responseHeader;
    this.lastCounterResetTime = lastCounterResetTime;
    this.servers = servers;
  }

  public ResponseHeader getResponseHeader() {
    return responseHeader;
  }

  public long getLastCounterResetTime() {
    return lastCounterResetTime;
  }

  public List<ServerOnNetwork> getServers() {
    return servers;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("FindServersOnNetworkResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, writeComplex(writeBuffer));

    // Simple Field (lastCounterResetTime)
    writeSimpleField(
        "lastCounterResetTime", lastCounterResetTime, writeSignedLong(writeBuffer, 64));

    // Implicit Field (noOfServers) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfServers = (int) ((((getServers()) == (null)) ? -(1) : COUNT(getServers())));
    writeImplicitField("noOfServers", noOfServers, writeSignedInt(writeBuffer, 32));

    // Array Field (servers)
    writeComplexTypeArrayField("servers", servers, writeBuffer);

    writeBuffer.popContext("FindServersOnNetworkResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    FindServersOnNetworkResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Simple field (lastCounterResetTime)
    lengthInBits += 64;

    // Implicit Field (noOfServers)
    lengthInBits += 32;

    // Array field
    if (servers != null) {
      int i = 0;
      for (ServerOnNetwork element : servers) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= servers.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("FindServersOnNetworkResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ResponseHeader responseHeader =
        readSimpleField(
            "responseHeader",
            readComplex(
                () ->
                    (ResponseHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (394)),
                readBuffer));

    long lastCounterResetTime =
        readSimpleField("lastCounterResetTime", readSignedLong(readBuffer, 64));

    int noOfServers = readImplicitField("noOfServers", readSignedInt(readBuffer, 32));

    List<ServerOnNetwork> servers =
        readCountArrayField(
            "servers",
            readComplex(
                () ->
                    (ServerOnNetwork)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (12191)),
                readBuffer),
            noOfServers);

    readBuffer.closeContext("FindServersOnNetworkResponse");
    // Create the instance
    return new FindServersOnNetworkResponseBuilderImpl(
        responseHeader, lastCounterResetTime, servers);
  }

  public static class FindServersOnNetworkResponseBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ResponseHeader responseHeader;
    private final long lastCounterResetTime;
    private final List<ServerOnNetwork> servers;

    public FindServersOnNetworkResponseBuilderImpl(
        ResponseHeader responseHeader, long lastCounterResetTime, List<ServerOnNetwork> servers) {
      this.responseHeader = responseHeader;
      this.lastCounterResetTime = lastCounterResetTime;
      this.servers = servers;
    }

    public FindServersOnNetworkResponse build() {
      FindServersOnNetworkResponse findServersOnNetworkResponse =
          new FindServersOnNetworkResponse(responseHeader, lastCounterResetTime, servers);
      return findServersOnNetworkResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof FindServersOnNetworkResponse)) {
      return false;
    }
    FindServersOnNetworkResponse that = (FindServersOnNetworkResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getLastCounterResetTime() == that.getLastCounterResetTime())
        && (getServers() == that.getServers())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getResponseHeader(), getLastCounterResetTime(), getServers());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
