/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableAudit {
  AuditEventType_ActionTimeStamp((int) 2053L),
  AuditEventType_Status((int) 2054L),
  AuditEventType_ServerId((int) 2055L),
  AuditEventType_ClientAuditEntryId((int) 2056L),
  AuditEventType_ClientUserId((int) 2057L),
  AuditOpenSecureChannelEventType_ClientCertificate((int) 2061L),
  AuditOpenSecureChannelEventType_RequestType((int) 2062L),
  AuditOpenSecureChannelEventType_SecurityPolicyUri((int) 2063L),
  AuditOpenSecureChannelEventType_SecurityMode((int) 2065L),
  AuditOpenSecureChannelEventType_RequestedLifetime((int) 2066L),
  AuditSessionEventType_SessionId((int) 2070L),
  AuditCreateSessionEventType_SecureChannelId((int) 2072L),
  AuditCreateSessionEventType_ClientCertificate((int) 2073L),
  AuditCreateSessionEventType_RevisedSessionTimeout((int) 2074L),
  AuditActivateSessionEventType_ClientSoftwareCertificates((int) 2076L),
  AuditActivateSessionEventType_UserIdentityToken((int) 2077L),
  AuditCancelEventType_RequestHandle((int) 2079L),
  AuditCertificateEventType_Certificate((int) 2081L),
  AuditCertificateDataMismatchEventType_InvalidHostname((int) 2083L),
  AuditCertificateDataMismatchEventType_InvalidUri((int) 2084L),
  AuditAddNodesEventType_NodesToAdd((int) 2092L),
  AuditDeleteNodesEventType_NodesToDelete((int) 2094L),
  AuditAddReferencesEventType_ReferencesToAdd((int) 2096L),
  AuditDeleteReferencesEventType_ReferencesToDelete((int) 2098L),
  AuditWriteUpdateEventType_IndexRange((int) 2101L),
  AuditWriteUpdateEventType_OldValue((int) 2102L),
  AuditWriteUpdateEventType_NewValue((int) 2103L),
  AuditUpdateMethodEventType_MethodId((int) 2128L),
  AuditUpdateMethodEventType_InputArguments((int) 2129L),
  AuditChannelEventType_SecureChannelId((int) 2745L),
  AuditOpenSecureChannelEventType_ClientCertificateThumbprint((int) 2746L),
  AuditCreateSessionEventType_ClientCertificateThumbprint((int) 2747L),
  AuditUrlMismatchEventType_EndpointUrl((int) 2749L),
  AuditWriteUpdateEventType_AttributeId((int) 2750L),
  AuditHistoryUpdateEventType_ParameterDataTypeId((int) 2751L),
  AuditUpdateStateEventType_OldStateId((int) 2777L),
  AuditUpdateStateEventType_NewStateId((int) 2778L),
  AuditHistoryEventUpdateEventType_Filter((int) 3003L),
  AuditHistoryRawModifyDeleteEventType_IsDeleteModified((int) 3015L),
  AuditHistoryRawModifyDeleteEventType_StartTime((int) 3016L),
  AuditHistoryRawModifyDeleteEventType_EndTime((int) 3017L),
  AuditHistoryAtTimeDeleteEventType_ReqTimes((int) 3020L),
  AuditHistoryAtTimeDeleteEventType_OldValues((int) 3021L),
  AuditHistoryEventDeleteEventType_EventIds((int) 3023L),
  AuditHistoryEventDeleteEventType_OldValues((int) 3024L),
  AuditHistoryEventUpdateEventType_UpdatedNode((int) 3025L),
  AuditHistoryValueUpdateEventType_UpdatedNode((int) 3026L),
  AuditHistoryDeleteEventType_UpdatedNode((int) 3027L),
  AuditHistoryEventUpdateEventType_PerformInsertReplace((int) 3028L),
  AuditHistoryEventUpdateEventType_NewValues((int) 3029L),
  AuditHistoryEventUpdateEventType_OldValues((int) 3030L),
  AuditHistoryValueUpdateEventType_PerformInsertReplace((int) 3031L),
  AuditHistoryValueUpdateEventType_NewValues((int) 3032L),
  AuditHistoryValueUpdateEventType_OldValues((int) 3033L),
  AuditHistoryRawModifyDeleteEventType_OldValues((int) 3034L),
  AuditActivateSessionEventType_SecureChannelId((int) 11485L),
  AuditConditionCommentEventType_Comment((int) 11851L),
  AuditConditionRespondEventType_SelectedResponse((int) 11852L),
  AuditConditionAcknowledgeEventType_Comment((int) 11853L),
  AuditConditionConfirmEventType_Comment((int) 11854L),
  AuditConditionShelvingEventType_ShelvingTime((int) 11855L),
  AuditProgramTransitionEventType_TransitionNumber((int) 11875L),
  AuditConditionCommentEventType_ConditionEventId((int) 17222L),
  AuditConditionAcknowledgeEventType_ConditionEventId((int) 17223L),
  AuditConditionConfirmEventType_ConditionEventId((int) 17224L),
  AuditSecurityEventType_StatusCodeId((int) 17615L),
  AuditHistoryAnnotationUpdateEventType_PerformInsertReplace((int) 19293L),
  AuditHistoryAnnotationUpdateEventType_NewValues((int) 19294L),
  AuditHistoryAnnotationUpdateEventType_OldValues((int) 19295L),
  AuditActivateSessionEventType_CurrentRoleIds((int) 19304L),
  AuditUpdateMethodEventType_StatusCodeId((int) 19305L),
  AuditUpdateMethodEventType_OutputArguments((int) 19306L),
  AuditClientEventType_ServerUri((int) 23908L),
  AuditClientUpdateMethodResultEventType_ObjectId((int) 23994L),
  AuditClientUpdateMethodResultEventType_MethodId((int) 23995L),
  AuditClientUpdateMethodResultEventType_StatusCodeId((int) 23998L),
  AuditClientUpdateMethodResultEventType_InputArguments((int) 23999L),
  AuditOpenSecureChannelEventType_CertificateErrorEventId((int) 24135L),
  AuditClientUpdateMethodResultEventType_OutputArguments((int) 25684L),
  AuditHistoryBulkInsertEventType_UpdatedNode((int) 32821L),
  AuditHistoryBulkInsertEventType_StartTime((int) 32822L),
  AuditHistoryBulkInsertEventType_EndTime((int) 32823L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableAudit> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableAudit value : OpcuaNodeIdServicesVariableAudit.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableAudit(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableAudit enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
