/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind;

import java.util.logging.Level;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;

public final class ScopedIdentifier<T> {
    private static final Object DUPLICATED = Void.TYPE;
    private final Class<? extends T> scope;
    private final String identifier;

    public ScopedIdentifier(Class<? extends T> scope, String identifier) {
        this.scope = scope;
        this.identifier = identifier;
    }

    public ScopedIdentifier<T> rename(String alt) {
        return alt.equals(this.identifier) ? this : new ScopedIdentifier<T>(this.scope, alt);
    }

    public void store(Class<T> base, T object, Class<?> caller, String method) {
        Context context = Context.current();
        if (context != null) {
            boolean warn = caller != null;
            ScopedIdentifier<T> key = this;
            Class[] parents = Classes.getAllInterfaces(this.scope);
            int index = -1;
            while (true) {
                Class parent;
                Object previous;
                if ((previous = context.identifiedObjects.putIfAbsent(key, object)) != null && previous != object && previous != DUPLICATED) {
                    context.identifiedObjects.put(key, DUPLICATED);
                    if (warn) {
                        warn = false;
                        Context.warningOccured(context, key == this ? Level.WARNING : Level.FINE, caller, method, null, Errors.class, (short)39, this.identifier);
                    }
                }
                do {
                    if (++index < parents.length) continue;
                    return;
                } while (!base.isAssignableFrom(parent = parents[index]));
                key = new ScopedIdentifier<T>(parent, this.identifier);
            }
        }
    }

    public T get(Context context) {
        Object value = context.identifiedObjects.get(this);
        return value != DUPLICATED ? (T)this.scope.cast(value) : null;
    }

    public int hashCode() {
        return this.scope.hashCode() + this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScopedIdentifier) {
            ScopedIdentifier other = (ScopedIdentifier)obj;
            return this.scope.equals(other.scope) && this.identifier.equals(other.identifier);
        }
        return false;
    }

    public String toString() {
        return this.scope.getSimpleName() + ":" + this.identifier;
    }
}

