/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.GeneralEnvelope;

final class SubEnvelope
extends GeneralEnvelope {
    private static final long serialVersionUID = 7241242611077979466L;
    private final int beginIndex;
    private final int endIndex;

    SubEnvelope(double[] coordinates, int beginIndex, int endIndex) {
        super(coordinates);
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    @Override
    final int beginIndex() {
        return this.beginIndex;
    }

    @Override
    final int endIndex() {
        return this.endIndex;
    }

    @Override
    public int getDimension() {
        return this.endIndex - this.beginIndex;
    }

    @Override
    public double getLower(int dimension) throws IndexOutOfBoundsException {
        return this.coordinates[Objects.checkIndex(dimension, this.endIndex) + this.beginIndex];
    }

    @Override
    public double getUpper(int dimension) throws IndexOutOfBoundsException {
        return this.coordinates[Objects.checkIndex(dimension, this.endIndex) + this.beginIndex + (this.coordinates.length >>> 1)];
    }

    @Override
    public void setRange(int dimension, double lower, double upper) throws IndexOutOfBoundsException {
        Objects.checkIndex(dimension, this.endIndex);
        if (lower > upper && this.crs != null && !SubEnvelope.isWrapAround(this.crs, dimension)) {
            throw new IllegalArgumentException(SubEnvelope.illegalRange(this.crs, dimension, lower, upper));
        }
        this.coordinates[(dimension += this.beginIndex) + (this.coordinates.length >>> 1)] = upper;
        this.coordinates[dimension] = lower;
    }

    @Override
    public void setEnvelope(double ... corners) {
        int dimension = this.getDimension();
        SubEnvelope.verifyArrayLength(dimension, corners);
        SubEnvelope.verifyRanges(this.crs, corners);
        int d = this.coordinates.length >>> 1;
        System.arraycopy(corners, 0, this.coordinates, this.beginIndex, dimension);
        System.arraycopy(corners, dimension, this.coordinates, this.beginIndex + d, dimension);
    }

    @Override
    public boolean isAllNaN() {
        int d = this.coordinates.length >>> 1;
        for (int i = this.beginIndex; i < this.endIndex; ++i) {
            if (Double.isNaN(this.coordinates[i]) && Double.isNaN(this.coordinates[i + d])) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    @Override
    public void setToNaN() {
        int d = this.coordinates.length >>> 1;
        Arrays.fill(this.coordinates, this.beginIndex, this.endIndex, Double.NaN);
        Arrays.fill(this.coordinates, this.beginIndex + d, this.endIndex + d, Double.NaN);
        assert (this.isAllNaN()) : this;
    }

    @Override
    public int hashCode() {
        return this.hashCodeByAPI();
    }

    @Override
    public boolean equals(Object object) {
        return this.equalsByAPI(object);
    }

    @Override
    public GeneralEnvelope subEnvelope(int b, int e) throws IndexOutOfBoundsException {
        Objects.checkFromToIndex(b, e, this.endIndex - this.beginIndex);
        return new SubEnvelope(this.coordinates, b + this.beginIndex, e + this.beginIndex);
    }

    @Override
    public GeneralEnvelope clone() {
        int d = this.coordinates.length >>> 1;
        int dimension = this.endIndex - this.beginIndex;
        GeneralEnvelope copy = new GeneralEnvelope(this.endIndex - this.beginIndex);
        System.arraycopy(this.coordinates, this.beginIndex, copy.coordinates, 0, dimension);
        System.arraycopy(this.coordinates, this.beginIndex + d, copy.coordinates, dimension, dimension);
        copy.crs = this.crs;
        return copy;
    }
}

