/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.annotation.Public;

@Public
public final class Watermark
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<SimpleDateFormat> TS_FORMATTER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    public static final Watermark MAX_WATERMARK = new Watermark(Long.MAX_VALUE);
    private final long timestamp;

    public Watermark(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getFormattedTimestamp() {
        return TS_FORMATTER.get().format(new Date(this.timestamp));
    }

    public boolean equals(Object o) {
        return this == o || o != null && o.getClass() == Watermark.class && ((Watermark)o).timestamp == this.timestamp;
    }

    public int hashCode() {
        return Long.hashCode(this.timestamp);
    }

    public String toString() {
        return "Watermark @ " + this.timestamp + " (" + this.getFormattedTimestamp() + ')';
    }
}

