/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.springframework.util.Assert;
import org.springframework.util.FilteredIterator;

class FilteredCollection<E>
extends AbstractCollection<E> {
    private final Collection<E> delegate;
    private final Predicate<E> filter;

    public FilteredCollection(Collection<E> delegate, Predicate<E> filter) {
        Assert.notNull(delegate, "Delegate must not be null");
        Assert.notNull(filter, "Filter must not be null");
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public int size() {
        int size = 0;
        for (E e : this.delegate) {
            if (!this.filter.test(e)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public Iterator<E> iterator() {
        return new FilteredIterator<E>(this.delegate.iterator(), this.filter);
    }

    @Override
    public boolean add(E e) {
        boolean added = this.delegate.add(e);
        return added && this.filter.test(e);
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.delegate.remove(o);
        return removed && this.filter.test(o);
    }

    @Override
    public boolean contains(Object o) {
        if (this.delegate.contains(o)) {
            return this.filter.test(o);
        }
        return false;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

