/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import java.util.Optional;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public enum ReferenceType {
    HEADER("headers"),
    SCHEMA("schemas"),
    SECURITY_SCHEME("securitySchemes"),
    CALLBACK("callbacks"),
    LINK("links"),
    RESPONSE("responses"),
    PARAMETER("parameters"),
    EXAMPLE("examples"),
    REQUEST_BODY("requestBodies");

    private static final Pattern COMPONENT_KEY_PATTERN;
    public static final String PROP_ANNOTATION = "ref";
    public static final String PROP_STANDARD = "$ref";
    String componentPath;

    private ReferenceType(String componentPath) {
        this.componentPath = componentPath;
    }

    public static ReferenceType fromComponentPath(String path) {
        for (ReferenceType ref : ReferenceType.values()) {
            if (!ref.componentPath.equals(path)) continue;
            return ref;
        }
        return null;
    }

    public static boolean isReference(AnnotationInstance annotation) {
        return annotation != null && annotation.value(PROP_ANNOTATION) != null;
    }

    public static String referenceValue(AnnotationInstance annotation) {
        return Optional.ofNullable(annotation.value(PROP_ANNOTATION)).map(AnnotationValue::asString).orElse(null);
    }

    public String referencePrefix() {
        return "#/components/" + this.componentPath;
    }

    public String referenceOf(String ref) {
        return this.referencePrefix() + "/" + ref;
    }

    public String refValue(AnnotationInstance annotation) {
        String ref = ReferenceType.referenceValue(annotation);
        if (ref == null) {
            return null;
        }
        if (!COMPONENT_KEY_PATTERN.matcher(ref).matches()) {
            return ref;
        }
        return this.referenceOf(ref);
    }

    static {
        COMPONENT_KEY_PATTERN = Pattern.compile("^[a-zA-Z0-9\\.\\-_]+$");
    }
}

