/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jpa.integration.eclipselink;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.openejb.jpa.integration.JPAThreadContext;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.Session;

public class PrefixSessionCustomizer
implements SessionCustomizer {
    public void customize(Session session) throws Exception {
        if (JPAThreadContext.infos.containsKey("properties")) {
            String prefix = ((Properties)JPAThreadContext.infos.get("properties")).getProperty("openejb.jpa.table_prefix");
            ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>();
            for (ClassDescriptor cd : session.getDescriptors().values()) {
                for (DatabaseTable table : cd.getTables()) {
                    this.update(prefix, tables, table);
                }
                for (DatabaseMapping mapping : cd.getMappings()) {
                    if (mapping instanceof ManyToManyMapping) {
                        this.update(prefix, tables, ((ManyToManyMapping)mapping).getRelationTable());
                        continue;
                    }
                    if (!(mapping instanceof DirectCollectionMapping)) continue;
                    this.update(prefix, tables, ((DirectCollectionMapping)mapping).getReferenceTable());
                }
            }
            Sequence sequence = session.getDatasourcePlatform().getDefaultSequence();
            if (sequence instanceof TableSequence) {
                TableSequence ts = (TableSequence)sequence;
                ts.setName(prefix + ts.getName());
            }
        }
    }

    private void update(String prefix, List<DatabaseTable> tables, DatabaseTable table) {
        if (!tables.contains(table)) {
            table.setName(prefix + table.getName());
            tables.add(table);
        }
    }
}

