/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetRepositoriesAction
extends TransportMasterNodeReadAction<GetRepositoriesRequest, GetRepositoriesResponse> {
    @Inject
    public TransportGetRepositoriesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/get", transportService, clusterService, threadPool, actionFilters, GetRepositoriesRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected GetRepositoriesResponse read(StreamInput in) throws IOException {
        return new GetRepositoriesResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(GetRepositoriesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetRepositoriesRequest request, ClusterState state, ActionListener<GetRepositoriesResponse> listener) {
        MetaData metaData = state.metaData();
        RepositoriesMetaData repositories = (RepositoriesMetaData)metaData.custom("repositories");
        if (request.repositories().length == 0 || request.repositories().length == 1 && "_all".equals(request.repositories()[0])) {
            if (repositories != null) {
                listener.onResponse(new GetRepositoriesResponse(repositories));
            } else {
                listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetaData(Collections.emptyList())));
            }
        } else if (repositories != null) {
            LinkedHashSet<String> repositoriesToGet = new LinkedHashSet<String>();
            for (String repositoryOrPattern : request.repositories()) {
                if (!Regex.isSimpleMatchPattern(repositoryOrPattern)) {
                    repositoriesToGet.add(repositoryOrPattern);
                    continue;
                }
                for (RepositoryMetaData repository : repositories.repositories()) {
                    if (!Regex.simpleMatch(repositoryOrPattern, repository.name())) continue;
                    repositoriesToGet.add(repository.name());
                }
            }
            ArrayList<RepositoryMetaData> repositoryListBuilder = new ArrayList<RepositoryMetaData>();
            for (String repository : repositoriesToGet) {
                RepositoryMetaData repositoryMetaData = repositories.repository(repository);
                if (repositoryMetaData == null) {
                    listener.onFailure(new RepositoryMissingException(repository));
                    return;
                }
                repositoryListBuilder.add(repositoryMetaData);
            }
            listener.onResponse(new GetRepositoriesResponse(new RepositoriesMetaData(repositoryListBuilder)));
        } else {
            listener.onFailure(new RepositoryMissingException(request.repositories()[0]));
        }
    }
}

