/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.alternative.Test;
import org.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.apache.xerces.impl.xs.util.ObjectListImpl;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSTypeAlternative;
import org.apache.xerces.xs.datatypes.ObjectList;

public class XSDTypeAlternativeValidator {
    XMLSchemaValidator fXmlSchemaValidator = null;

    public XSDTypeAlternativeValidator(XMLSchemaValidator xMLSchemaValidator) {
        this.fXmlSchemaValidator = xMLSchemaValidator;
    }

    public XSTypeAlternative getTypeAlternative(XSElementDecl xSElementDecl, QName qName, XMLAttributes xMLAttributes, Vector vector, NamespaceContext namespaceContext, String string) {
        XSTypeAlternativeImpl xSTypeAlternativeImpl = null;
        XSTypeAlternativeImpl[] xSTypeAlternativeImplArray = xSElementDecl.getTypeAlternatives();
        if (xSTypeAlternativeImplArray != null) {
            XMLAttributes xMLAttributes2 = this.getAttributesForCTA(xMLAttributes, vector);
            for (int i = 0; i < xSTypeAlternativeImplArray.length; ++i) {
                Test test = xSTypeAlternativeImplArray[i].getTest();
                if (test == null || !test.evaluateTest(qName, xMLAttributes2, namespaceContext, string)) continue;
                xSTypeAlternativeImpl = xSTypeAlternativeImplArray[i];
                break;
            }
            if (xSTypeAlternativeImpl == null) {
                xSTypeAlternativeImpl = xSElementDecl.getDefaultTypeDefinition();
            }
        }
        return xSTypeAlternativeImpl;
    }

    private XMLAttributes getAttributesForCTA(XMLAttributes xMLAttributes, Vector vector) {
        Object object;
        int n;
        XMLAttributesImpl xMLAttributesImpl = new XMLAttributesImpl();
        for (n = 0; n < xMLAttributes.getLength(); ++n) {
            object = new QName();
            xMLAttributes.getName(n, (QName)object);
            xMLAttributesImpl.addAttribute((QName)object, xMLAttributes.getType(n), xMLAttributes.getValue(n));
        }
        for (n = vector.size() - 1; n > -1; --n) {
            object = (AttributePSVI)vector.elementAt(n);
            XSAttributeDeclaration xSAttributeDeclaration = object.getAttributeDeclaration();
            if (this.isInheritedAttributeOverridden(xMLAttributesImpl, xSAttributeDeclaration)) continue;
            QName qName = new QName();
            qName.setValues(null, xSAttributeDeclaration.getName(), xSAttributeDeclaration.getName(), xSAttributeDeclaration.getNamespace());
            xMLAttributesImpl.addAttribute(qName, null, object.getSchemaValue().getNormalizedValue());
        }
        return xMLAttributesImpl;
    }

    private boolean isInheritedAttributeOverridden(XMLAttributes xMLAttributes, XSAttributeDeclaration xSAttributeDeclaration) {
        boolean bl = false;
        for (int i = 0; i < xMLAttributes.getLength(); ++i) {
            if (!xMLAttributes.getLocalName(i).equals(xSAttributeDeclaration.getName()) || !XS11TypeHelper.isURIEqual(xMLAttributes.getURI(i), xSAttributeDeclaration.getNamespace())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    void saveInheritableAttributes(XSElementDecl xSElementDecl, XMLAttributes xMLAttributes) {
        if (xSElementDecl != null && xSElementDecl.fType instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSElementDecl.fType;
            XSObjectListImpl xSObjectListImpl = (XSObjectListImpl)xSComplexTypeDecl.getAttributeUses();
            for (int i = 0; i < xSObjectListImpl.getLength(); ++i) {
                XSAttributeDeclaration xSAttributeDeclaration;
                Augmentations augmentations;
                XSAttributeUse xSAttributeUse = (XSAttributeUse)xSObjectListImpl.get(i);
                if (!xSAttributeUse.getInheritable() || (augmentations = xMLAttributes.getAugmentations((xSAttributeDeclaration = xSAttributeUse.getAttrDeclaration()).getNamespace(), xSAttributeDeclaration.getName())) == null) continue;
                this.fXmlSchemaValidator.getInheritableAttrList().add((AttributePSVI)augmentations.getItem("ATTRIBUTE_PSVI"));
            }
        }
    }

    ObjectList getInheritedAttributesForPSVI() {
        ObjectListImpl objectListImpl = null;
        Vector vector = this.fXmlSchemaValidator.getInheritableAttrList();
        if (vector.size() > 0) {
            Object[] objectArray = new Object[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                objectArray[i] = vector.get(i);
            }
            objectListImpl = new ObjectListImpl(objectArray, objectArray.length);
        }
        return objectListImpl;
    }
}

