/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ItemType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.KindTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SequenceType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.w3c.dom.Node;

public class SeqType {
    public static final int OCC_NONE = 0;
    public static final int OCC_STAR = 1;
    public static final int OCC_PLUS = 2;
    public static final int OCC_QMARK = 3;
    public static final int OCC_EMPTY = 4;
    public static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final QName ANY_ATOMIC_TYPE = new QName("xs", "anyAtomicType", "http://www.w3.org/2001/XMLSchema");
    private transient AnyType anytype = null;
    private transient int occ;
    private transient Class typeClass = null;
    private transient QName nodeName = null;
    private transient boolean wild = false;

    public SeqType(AnyType t, int occ) {
        this.anytype = t;
        this.occ = occ;
        this.typeClass = t != null ? t.getClass() : null;
    }

    public SeqType(int occ) {
        this((AnyType)null, occ);
        this.typeClass = NodeType.class;
    }

    public SeqType(Class type_class, int occ) {
        this((AnyType)null, occ);
        this.typeClass = type_class;
    }

    public SeqType(SequenceType st, StaticContext sc, ResultSequence rs) {
        switch (st.occurrence()) {
            case 0: {
                this.occ = 4;
                return;
            }
            case 1: {
                this.occ = 0;
                break;
            }
            case 2: {
                this.occ = 3;
                break;
            }
            case 3: {
                this.occ = 1;
                break;
            }
            case 4: {
                this.occ = 2;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        ItemType item = st.item_type();
        KindTest ktest = null;
        switch (item.type()) {
            case 0: {
                this.typeClass = AnyType.class;
                return;
            }
            case 1: {
                AnyAtomicType aat = sc.make_atomic(item.qname());
                assert (aat != null);
                this.anytype = aat;
                this.typeClass = item.qname().equals(ANY_ATOMIC_TYPE) ? AnyAtomicType.class : this.anytype.getClass();
                return;
            }
            case 2: {
                ktest = item.kind_test();
            }
        }
        if (ktest == null) {
            return;
        }
        this.typeClass = ktest.getXDMClassType();
        this.anytype = ktest.createTestType(rs);
        this.nodeName = ktest.name();
        this.wild = ktest.isWild();
    }

    public SeqType(AnyType t) {
        this(t, 0);
    }

    public int occurence() {
        return this.occ;
    }

    public AnyType type() {
        return this.anytype;
    }

    public ResultSequence match(ResultSequence args) throws DynamicError {
        int occurrence = this.occurence();
        if (occurrence == 4 && !args.empty()) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        int arg_count = 0;
        ListIterator i = args.iterator();
        while (i.hasNext()) {
            AnyType arg = (AnyType)i.next();
            if (!this.typeClass.isInstance(arg)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            if (this.anytype != null && (this.nodeName != null || this.wild) && arg instanceof NodeType) {
                NodeType nodeType = (NodeType)arg;
                Node node = nodeType.node_value();
                Node lnode = ((NodeType)this.anytype).node_value();
                if (lnode == null || !lnode.isEqualNode(node)) continue;
            }
            ++arg_count;
        }
        switch (occurrence) {
            case 0: {
                if (arg_count == true) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            case 2: {
                if (arg_count != 0) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            case 1: {
                break;
            }
            case 3: {
                if (arg_count <= true) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            default: {
                assert (false);
                break;
            }
        }
        return args;
    }
}

