/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.spring.namespace.xml;

import org.jboss.windup.config.spring.namespace.java.SpringNamespaceHandlerUtil;
import org.jboss.windup.decorator.xml.XPathValueDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class XPathValueBeanParser
extends AbstractBeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(XPathValueBeanParser.class);

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanBuilder = BeanDefinitionBuilder.rootBeanDefinition(XPathValueDecorator.class);
        beanBuilder.addPropertyValue("xpathExpression", (Object)element.getAttribute("xpath"));
        beanBuilder.addPropertyValue("matchDescription", (Object)element.getAttribute("description"));
        if (element.hasAttribute("inline")) {
            beanBuilder.addPropertyValue("inline", (Object)element.getAttribute("inline"));
        }
        if (element.hasAttribute("effort")) {
            LOG.debug("Effort: " + element.getAttribute("effort"));
            BeanDefinitionBuilder effortBean = BeanDefinitionBuilder.genericBeanDefinition((String)"org.jboss.windup.metadata.decoration.effort.StoryPointEffort");
            effortBean.addPropertyValue("hours", (Object)element.getAttribute("effort"));
            beanBuilder.addPropertyValue("effort", (Object)effortBean.getBeanDefinition());
        } else {
            BeanDefinitionBuilder effortBean = BeanDefinitionBuilder.genericBeanDefinition((String)"org.jboss.windup.metadata.decoration.effort.UnknownEffort");
            beanBuilder.addPropertyValue("effort", (Object)effortBean.getBeanDefinition());
        }
        SpringNamespaceHandlerUtil.parseNamespaceMap(beanBuilder, element);
        SpringNamespaceHandlerUtil.setNestedList(beanBuilder, element, "hints", parserContext);
        SpringNamespaceHandlerUtil.setNestedList(beanBuilder, element, "decorators", parserContext);
        return beanBuilder.getBeanDefinition();
    }
}

