/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decorator.archive;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.decorator.archive.ManifestDecorator;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.archetype.version.PomVersion;
import org.jboss.windup.metadata.decoration.archetype.version.Version;
import org.jboss.windup.metadata.type.ManifestMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestVersionDecorator
extends ManifestDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestVersionDecorator.class);
    protected List<String> versionPriority;
    protected List<String> namePriority;

    public void setVersionPriority(List<String> versionPriority) {
        this.versionPriority = versionPriority;
    }

    public void setNamePriority(List<String> namePriority) {
        this.namePriority = namePriority;
    }

    @Override
    public void processMeta(ManifestMetadata file) {
        for (AbstractDecoration dr : file.getArchiveMeta().getDecorations()) {
            if (!(dr instanceof PomVersion)) continue;
            LOG.debug("Already has version result: " + dr.toString());
            return;
        }
        String name = null;
        String version = this.extractValue(file.getManifest(), this.versionPriority);
        if ((version = this.cleanseValue(version)) != null) {
            name = this.extractValue(file.getManifest(), this.namePriority);
            if (StringUtils.isBlank((String)(name = this.cleanseValue(name)))) {
                name = this.extractNameFromArchiveName(file.getArchiveMeta().getName());
            }
        }
        if (StringUtils.isNotBlank(name) && StringUtils.isNotBlank((String)version)) {
            Version vr = new Version();
            vr.setName(name);
            vr.setVersion(version);
            file.getArchiveMeta().getDecorations().add(vr);
            return;
        }
    }

    private String extractNameFromArchiveName(String archiveName) {
        String[] nameArray;
        String name = archiveName;
        name = StringUtils.substringBefore((String)name, (String)".");
        StringBuilder nameBuilder = new StringBuilder();
        for (String nameFrag : nameArray = StringUtils.split((String)name, (String)"-")) {
            if (!StringUtils.isNotBlank((String)nameFrag) || StringUtils.isNumeric((String)StringUtils.substring((String)nameFrag, (int)0, (int)1))) continue;
            nameBuilder.append(nameFrag).append("-");
        }
        name = nameBuilder.toString();
        if (StringUtils.endsWith((String)name, (String)"-")) {
            name = StringUtils.substringBeforeLast((String)name, (String)"-");
        }
        return name;
    }
}

