/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.interrogator;

import java.io.File;
import java.util.List;
import org.jboss.windup.interrogator.Interrogator;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.metadata.type.archive.DirectoryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInterrogationEngine {
    private static final Logger LOG = LoggerFactory.getLogger(FileInterrogationEngine.class);
    protected List<Interrogator> interrogators;

    public void setInterrogators(List<Interrogator> interrogators) {
        this.interrogators = interrogators;
    }

    public FileMetadata process(File targetFile) {
        FileMetadata tempMeta = new FileMetadata();
        tempMeta.setFilePointer(targetFile);
        DirectoryMetadata dirMeta = new DirectoryMetadata();
        dirMeta.setRelativePath(targetFile.getParentFile().getPath());
        tempMeta.setArchiveMeta((ArchiveMetadata)dirMeta);
        if (targetFile.isFile()) {
            LOG.debug("Processing file: " + targetFile.getAbsolutePath());
            for (Interrogator interrogator : this.interrogators) {
                interrogator.processFile(tempMeta);
            }
        }
        FileMetadata result = null;
        for (FileMetadata archiveEntryMeta : tempMeta.getArchiveMeta().getEntries()) {
            if (!archiveEntryMeta.getFilePointer().equals(tempMeta.getFilePointer())) continue;
            result = archiveEntryMeta;
            break;
        }
        return result;
    }
}

